local assets=
{
	Asset("ANIM", "anim/m203.zip"),
	Asset("ATLAS", "images/inventoryimages/m203.xml"),
    Asset("IMAGE", "images/inventoryimages/m203.tex"),
}

local prefabs =
{
	"explode_small",
}

local function OnHit(inst, owner, target)
    inst:Remove()    
	SpawnPrefab("explode_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("m203")
    inst.AnimState:SetBuild("m203")
    inst.AnimState:PlayAnimation("idle", false)
    		
    inst:AddTag("projectile")
					
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(40)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
		
	inst:AddComponent("explosive")
    inst.components.explosive.explosivedamage = 281
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/m203.xml"

	return inst
end

return Prefab( "common/inventory/m203", fncommon, assets)
